/*
 * Decompiled with CFR 0.152.
 */
package LZMA;

import LZMA.CRangeDecoder;
import LZMA.LzmaException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LzmaInputStream
extends FilterInputStream {
    boolean isClosed = false;
    CRangeDecoder RangeDecoder;
    byte[] dictionary;
    int dictionarySize;
    int dictionaryPos;
    int GlobalPos;
    int rep0;
    int rep1;
    int rep2;
    int rep3;
    int lc;
    int lp;
    int pb;
    int State;
    boolean PreviousIsMatch;
    int RemainLen;
    int[] probs;
    byte[] uncompressed_buffer;
    int uncompressed_size;
    int uncompressed_offset;
    long GlobalNowPos;
    long GlobalOutSize;
    static final int LZMA_BASE_SIZE = 1846;
    static final int LZMA_LIT_SIZE = 768;
    static final int kBlockSize = 65536;
    static final int kNumStates = 12;
    static final int kStartPosModelIndex = 4;
    static final int kEndPosModelIndex = 14;
    static final int kNumFullDistances = 128;
    static final int kNumPosSlotBits = 6;
    static final int kNumLenToPosStates = 4;
    static final int kNumAlignBits = 4;
    static final int kAlignTableSize = 16;
    static final int kMatchMinLen = 2;
    static final int IsMatch = 0;
    static final int IsRep = 192;
    static final int IsRepG0 = 204;
    static final int IsRepG1 = 216;
    static final int IsRepG2 = 228;
    static final int IsRep0Long = 240;
    static final int PosSlot = 432;
    static final int SpecPos = 688;
    static final int Align = 802;
    static final int LenCoder = 818;
    static final int RepLenCoder = 1332;
    static final int Literal = 1846;

    public LzmaInputStream(InputStream in) throws IOException {
        super(in);
        this.readHeader();
        this.fill_buffer();
    }

    /*
     * Unable to fully structure code
     */
    private void LzmaDecode(int outSize) throws IOException {
        posStateMask = (1 << this.pb) - 1;
        literalPosMask = (1 << this.lp) - 1;
        this.uncompressed_size = 0;
        if (this.RemainLen != -1) ** GOTO lbl13
        return;
lbl-1000:
        // 1 sources

        {
            pos = this.dictionaryPos - this.rep0;
            if (pos < 0) {
                pos += this.dictionarySize;
            }
            this.uncompressed_buffer[this.uncompressed_size++] = this.dictionary[this.dictionaryPos] = this.dictionary[pos];
            if (++this.dictionaryPos == this.dictionarySize) {
                this.dictionaryPos = 0;
            }
            --this.RemainLen;
lbl13:
            // 2 sources

            ** while (this.RemainLen > 0 && this.uncompressed_size < outSize)
        }
lbl14:
        // 1 sources

        previousbyte = this.dictionaryPos == 0 ? this.dictionary[this.dictionarySize - 1] : this.dictionary[this.dictionaryPos - 1];
        while (this.uncompressed_size < outSize) {
            posState = this.uncompressed_size + this.GlobalPos & posStateMask;
            if (this.RangeDecoder.BitDecode(this.probs, 0 + (this.State << 4) + posState) == 0) {
                ind_prob = 1846 + 768 * (((this.uncompressed_size + this.GlobalPos & literalPosMask) << this.lc) + ((previousbyte & 255) >> 8 - this.lc));
                this.State = this.State < 4 ? 0 : (this.State < 10 ? (this.State -= 3) : (this.State -= 6));
                if (this.PreviousIsMatch) {
                    pos = this.dictionaryPos - this.rep0;
                    if (pos < 0) {
                        pos += this.dictionarySize;
                    }
                    matchbyte = this.dictionary[pos];
                    previousbyte = this.RangeDecoder.LzmaLiteralDecodeMatch(this.probs, ind_prob, matchbyte);
                    this.PreviousIsMatch = false;
                } else {
                    previousbyte = this.RangeDecoder.LzmaLiteralDecode(this.probs, ind_prob);
                }
                this.uncompressed_buffer[this.uncompressed_size++] = previousbyte;
                this.dictionary[this.dictionaryPos] = previousbyte;
                if (++this.dictionaryPos != this.dictionarySize) continue;
                this.dictionaryPos = 0;
                continue;
            }
            this.PreviousIsMatch = true;
            if (this.RangeDecoder.BitDecode(this.probs, 192 + this.State) == 1) {
                if (this.RangeDecoder.BitDecode(this.probs, 204 + this.State) == 0) {
                    if (this.RangeDecoder.BitDecode(this.probs, 240 + (this.State << 4) + posState) == 0) {
                        if (this.uncompressed_size + this.GlobalPos == 0) {
                            throw new LzmaException("LZMA : Data Error");
                        }
                        this.State = this.State < 7 ? 9 : 11;
                        pos = this.dictionaryPos - this.rep0;
                        if (pos < 0) {
                            pos += this.dictionarySize;
                        }
                        this.dictionary[this.dictionaryPos] = previousbyte = this.dictionary[pos];
                        if (++this.dictionaryPos == this.dictionarySize) {
                            this.dictionaryPos = 0;
                        }
                        this.uncompressed_buffer[this.uncompressed_size++] = previousbyte;
                        continue;
                    }
                } else {
                    if (this.RangeDecoder.BitDecode(this.probs, 216 + this.State) == 0) {
                        distance = this.rep1;
                    } else {
                        if (this.RangeDecoder.BitDecode(this.probs, 228 + this.State) == 0) {
                            distance = this.rep2;
                        } else {
                            distance = this.rep3;
                            this.rep3 = this.rep2;
                        }
                        this.rep2 = this.rep1;
                    }
                    this.rep1 = this.rep0;
                    this.rep0 = distance;
                }
                this.RemainLen = this.RangeDecoder.LzmaLenDecode(this.probs, 1332, posState);
                this.State = this.State < 7 ? 8 : 11;
            } else {
                this.rep3 = this.rep2;
                this.rep2 = this.rep1;
                this.rep1 = this.rep0;
                this.State = this.State < 7 ? 7 : 10;
                this.RemainLen = this.RangeDecoder.LzmaLenDecode(this.probs, 818, posState);
                posSlot = this.RangeDecoder.BitTreeDecode(this.probs, 432 + ((this.RemainLen < 4 ? this.RemainLen : 3) << 6), 6);
                if (posSlot >= 4) {
                    numDirectBits = (posSlot >> 1) - 1;
                    this.rep0 = (2 | posSlot & 1) << numDirectBits;
                    if (posSlot < 14) {
                        this.rep0 += this.RangeDecoder.ReverseBitTreeDecode(this.probs, 688 + this.rep0 - posSlot - 1, numDirectBits);
                    } else {
                        this.rep0 += this.RangeDecoder.DecodeDirectBits(numDirectBits - 4) << 4;
                        this.rep0 += this.RangeDecoder.ReverseBitTreeDecode(this.probs, 802, 4);
                    }
                } else {
                    this.rep0 = posSlot;
                }
                ++this.rep0;
            }
            if (this.rep0 == 0) {
                this.RemainLen = -1;
                break;
            }
            if (this.rep0 > this.uncompressed_size + this.GlobalPos) {
                throw new LzmaException("LZMA : Data Error");
            }
            this.RemainLen += 2;
            do {
                if ((pos = this.dictionaryPos - this.rep0) < 0) {
                    pos += this.dictionarySize;
                }
                this.dictionary[this.dictionaryPos] = previousbyte = this.dictionary[pos];
                if (++this.dictionaryPos == this.dictionarySize) {
                    this.dictionaryPos = 0;
                }
                this.uncompressed_buffer[this.uncompressed_size++] = previousbyte;
                --this.RemainLen;
            } while (this.RemainLen > 0 && this.uncompressed_size < outSize);
        }
        this.GlobalPos += this.uncompressed_size;
    }

    private void fill_buffer() throws IOException {
        if (this.GlobalNowPos < this.GlobalOutSize) {
            this.uncompressed_offset = 0;
            long lblockSize = this.GlobalOutSize - this.GlobalNowPos;
            int blockSize = lblockSize > 65536L ? 65536 : (int)lblockSize;
            this.LzmaDecode(blockSize);
            if (this.uncompressed_size == 0) {
                this.GlobalOutSize = this.GlobalNowPos;
            } else {
                this.GlobalNowPos += (long)this.uncompressed_size;
            }
        }
    }

    private void readHeader() throws IOException {
        int prop0;
        byte[] properties = new byte[5];
        if (5 != this.in.read(properties)) {
            throw new LzmaException("LZMA header corrupted : Properties error");
        }
        this.GlobalOutSize = 0L;
        int ii = 0;
        while (ii < 8) {
            int b = this.in.read();
            if (b == -1) {
                throw new LzmaException("LZMA header corrupted : Size error");
            }
            this.GlobalOutSize += (long)b << ii * 8;
            ++ii;
        }
        if (this.GlobalOutSize == -1L) {
            this.GlobalOutSize = Long.MAX_VALUE;
        }
        if ((prop0 = properties[0] & 0xFF) >= 225) {
            throw new LzmaException("LZMA header corrupted : Properties error");
        }
        this.pb = 0;
        while (prop0 >= 45) {
            ++this.pb;
            prop0 -= 45;
        }
        this.lp = 0;
        while (prop0 >= 9) {
            ++this.lp;
            prop0 -= 9;
        }
        this.lc = prop0;
        int lzmaInternalSize = 1846 + (768 << this.lc + this.lp);
        this.probs = new int[lzmaInternalSize];
        this.dictionarySize = 0;
        int i = 0;
        while (i < 4) {
            this.dictionarySize += (properties[1 + i] & 0xFF) << i * 8;
            ++i;
        }
        this.dictionary = new byte[this.dictionarySize];
        if (this.dictionary == null) {
            throw new LzmaException("LZMA : can't allocate");
        }
        int numProbs = 1846 + (768 << this.lc + this.lp);
        this.RangeDecoder = new CRangeDecoder(this.in);
        this.dictionaryPos = 0;
        this.GlobalPos = 0;
        this.rep3 = 1;
        this.rep2 = 1;
        this.rep1 = 1;
        this.rep0 = 1;
        this.State = 0;
        this.PreviousIsMatch = false;
        this.RemainLen = 0;
        this.dictionary[this.dictionarySize - 1] = 0;
        int i2 = 0;
        while (i2 < numProbs) {
            this.probs[i2] = 1024;
            ++i2;
        }
        this.uncompressed_buffer = new byte[65536];
        this.uncompressed_size = 0;
        this.uncompressed_offset = 0;
        this.GlobalNowPos = 0L;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("stream closed");
        }
        if ((off | len | off + len | buf.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.uncompressed_offset == this.uncompressed_size) {
            this.fill_buffer();
        }
        if (this.uncompressed_offset == this.uncompressed_size) {
            return -1;
        }
        int l = Math.min(len, this.uncompressed_size - this.uncompressed_offset);
        System.arraycopy(this.uncompressed_buffer, this.uncompressed_offset, buf, off, l);
        this.uncompressed_offset += l;
        return l;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        super.close();
    }
}

